<?php
include_once __DIR__ . '/url_config.php';
$appname = App_Name;
$app_link = App_Link;
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title><?php echo htmlspecialchars($appname); ?> - Admin Login</title>
    
    <link rel="shortcut icon" type="image/png" href="<?php echo htmlspecialchars($app_link); ?>" />
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    
    <style>
        :root {
            --primary: #00ffae;
            --primary-dark: #00cc8b;
            --secondary: #00d4ff;
            --gradient: linear-gradient(135deg, #00ffae 0%, #00d4ff 100%);
        }
        
        * {
            font-family: 'Poppins', sans-serif;
        }
        
        body {
            background: linear-gradient(135deg, #0f172a 0%, #1e293b 100%);
            position: relative;
            overflow-x: hidden;
            min-height: 100vh;
        }
        
        body::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: url('https://script.viserlab.com/viserpay/assets/admin/images/login.jpg') no-repeat center center/cover;
            opacity: 0.15;
            z-index: -1;
        }
        
        .gradient-text {
            background: var(--gradient);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
        
        .gradient-border {
            position: relative;
        }
        
        .gradient-border::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: var(--gradient);
            border-radius: 8px 8px 0 0;
        }
        
        .gradient-bg {
            background: var(--gradient);
        }
        
        .btn-hover-effect {
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }
        
        .btn-hover-effect:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(0, 255, 174, 0.4);
        }
        
        .btn-hover-effect:active {
            transform: translateY(0);
        }
        
        .btn-hover-effect::after {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 5px;
            height: 5px;
            background: rgba(255, 255, 255, 0.5);
            opacity: 0;
            border-radius: 100%;
            transform: scale(1, 1) translate(-50%);
            transform-origin: 50% 50%;
        }
        
        .btn-hover-effect:focus:not(:active)::after {
            animation: ripple 1s ease-out;
        }
        
        @keyframes ripple {
            0% {
                transform: scale(0, 0);
                opacity: 0.5;
            }
            100% {
                transform: scale(50, 50);
                opacity: 0;
            }
        }
        
        .floating {
            animation: floating 3s ease-in-out infinite;
        }
        
        @keyframes floating {
            0% { transform: translateY(0px); }
            50% { transform: translateY(-10px); }
            100% { transform: translateY(0px); }
        }
        
        .pulse-ring {
            animation: pulse 2s infinite;
        }
        
        @keyframes pulse {
            0% { box-shadow: 0 0 0 0 rgba(0, 255, 174, 0.7); }
            70% { box-shadow: 0 0 0 15px rgba(0, 255, 174, 0); }
            100% { box-shadow: 0 0 0 0 rgba(0, 255, 174, 0); }
        }
        
        .shake {
            animation: shake 0.5s ease-in-out;
        }
        
        @keyframes shake {
            0%, 100% { transform: translateX(0); }
            25% { transform: translateX(-5px); }
            75% { transform: translateX(5px); }
        }
        
        .fade-in {
            animation: fadeIn 0.8s ease-in-out;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .slide-in-left {
            animation: slideInLeft 0.8s ease-out;
        }
        
        @keyframes slideInLeft {
            from { opacity: 0; transform: translateX(-30px); }
            to { opacity: 1; transform: translateX(0); }
        }
        
        .slide-in-right {
            animation: slideInRight 0.8s ease-out;
        }
        
        @keyframes slideInRight {
            from { opacity: 0; transform: translateX(30px); }
            to { opacity: 1; transform: translateX(0); }
        }
        
        .loading-spinner {
            animation: spin 1s linear infinite;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        .glow {
            box-shadow: 0 0 15px rgba(0, 255, 174, 0.5);
        }
        
        input:focus {
            box-shadow: 0 0 0 3px rgba(0, 255, 174, 0.2);
        }
        
        .particle {
            position: absolute;
            border-radius: 50%;
            background: linear-gradient(135deg, rgba(0, 255, 174, 0.2), rgba(0, 212, 255, 0.2));
            z-index: -1;
        }
    </style>
</head>

<body class="flex items-center justify-center p-4 md:p-8">
    <!-- Background Particles -->
    <div id="particles-container" class="absolute inset-0 overflow-hidden"></div>
    
    <!-- Main Login Container -->
    <div class="w-full max-w-md fade-in">
        <div class="bg-slate-800/80 backdrop-blur-xl rounded-2xl shadow-2xl overflow-hidden border border-slate-700/50 gradient-border">
            <!-- Header with Logo -->
            <div class="p-8 pb-6 text-center">
                <div class="inline-flex items-center justify-center w-20 h-20 rounded-full gradient-bg mb-4 floating pulse-ring">
                    <i class="fas fa-wallet text-2xl text-slate-900"></i>
                </div>
                
                <h1 class="text-3xl font-bold gradient-text mb-2">
                    <?php echo htmlspecialchars($appname); ?>
                </h1>
                <p class="text-slate-400 text-sm mb-6 slide-in-left">
                    Admin Login to <?php echo htmlspecialchars($appname); ?> Dashboard
                </p>
                
                <!-- Error/Success Messages -->
                <?php if (isset($_GET['error'])): ?>
                <div class="mb-6 p-4 bg-red-500/10 border border-red-500/30 rounded-xl text-red-300 text-sm shake">
                    <div class="flex items-center">
                        <i class="fas fa-exclamation-circle mr-3"></i>
                        <span><?php echo htmlspecialchars($_GET['error']); ?></span>
                    </div>
                </div>
                <?php endif; ?>
                
                <?php if (isset($_GET['success'])): ?>
                <div class="mb-6 p-4 bg-green-500/10 border border-green-500/30 rounded-xl text-green-300 text-sm slide-in-right">
                    <div class="flex items-center">
                        <i class="fas fa-check-circle mr-3"></i>
                        <span><?php echo htmlspecialchars($_GET['success']); ?></span>
                    </div>
                </div>
                <?php endif; ?>
            </div>
            
            <!-- Login Form -->
            <div class="px-8 pb-8">
                <form action="admin/login.php" method="POST" id="loginForm">
                    <!-- Username Field -->
                    <div class="mb-6 slide-in-left" style="animation-delay: 0.1s">
                        <label for="username" class="block text-slate-300 text-sm font-medium mb-2">
                            <i class="fas fa-user mr-2"></i>Username
                        </label>
                        <div class="relative">
                            <input 
                                type="text" 
                                id="username" 
                                name="username" 
                                value="<?php echo isset($_GET['user']) ? htmlspecialchars($_GET['user']) : ''; ?>"
                                class="w-full bg-slate-900/60 border border-slate-700 text-slate-200 rounded-xl py-3 px-4 pl-12 focus:outline-none focus:border-cyan-400 transition duration-300"
                                placeholder="Enter your username"
                                required
                            />
                            <div class="absolute left-4 top-3.5 text-slate-400">
                                <i class="fas fa-user"></i>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Password Field -->
                    <div class="mb-6 slide-in-right" style="animation-delay: 0.2s">
                        <label for="password" class="block text-slate-300 text-sm font-medium mb-2">
                            <i class="fas fa-lock mr-2"></i>Password
                        </label>
                        <div class="relative">
                            <input 
                                type="password" 
                                id="password" 
                                name="password" 
                                class="w-full bg-slate-900/60 border border-slate-700 text-slate-200 rounded-xl py-3 px-4 pl-12 pr-12 focus:outline-none focus:border-cyan-400 transition duration-300"
                                placeholder="Enter your password"
                                required
                            />
                            <div class="absolute left-4 top-3.5 text-slate-400">
                                <i class="fas fa-lock"></i>
                            </div>
                            <button 
                                type="button" 
                                id="passwordToggle"
                                class="absolute right-4 top-3.5 text-slate-400 hover:text-cyan-400 transition duration-300"
                            >
                                <i class="far fa-eye"></i>
                            </button>
                        </div>
                    </div>
                    
                    <!-- Login Button -->
                    <button 
                        type="submit" 
                        id="loginButton"
                        class="w-full gradient-bg text-slate-900 font-semibold py-3.5 rounded-xl btn-hover-effect transition duration-300 relative overflow-hidden"
                    >
                        <span id="buttonText">LOGIN</span>
                        <div id="buttonSpinner" class="hidden absolute inset-0 flex items-center justify-center">
                            <div class="w-6 h-6 border-2 border-slate-900 border-t-transparent rounded-full loading-spinner"></div>
                        </div>
                    </button>
                </form>
                
                <!-- Footer -->
                <div class="mt-8 pt-6 border-t border-slate-700/50 text-center">
                    <p class="text-sm text-slate-500">
                        &copy; 2025 <?php echo htmlspecialchars($appname); ?>. All rights reserved.
                    </p>
                    <p class="text-xs text-slate-600 mt-2">
                        <i class="fas fa-shield-alt mr-1"></i> Secure Admin Portal
                    </p>
                </div>
            </div>
        </div>

    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Elements
            const loginForm = document.getElementById('loginForm');
            const passwordToggle = document.getElementById('passwordToggle');
            const passwordInput = document.getElementById('password');
            const loginButton = document.getElementById('loginButton');
            const buttonText = document.getElementById('buttonText');
            const buttonSpinner = document.getElementById('buttonSpinner');
            const usernameInput = document.getElementById('username');
            
            // Create background particles
            createParticles();
            
            // Toggle password visibility
            passwordToggle.addEventListener('click', function() {
                const type = passwordInput.getAttribute('type') === 'password' ? 'text' : 'password';
                passwordInput.setAttribute('type', type);
                
                // Toggle eye icon
                const icon = passwordToggle.querySelector('i');
                icon.classList.toggle('fa-eye');
                icon.classList.toggle('fa-eye-slash');
                
                // Add glow effect on toggle
                passwordInput.classList.add('glow');
                setTimeout(() => passwordInput.classList.remove('glow'), 500);
            });
            
            // Form submission with loading animation
            loginForm.addEventListener('submit', function(e) {
                // Show loading state
                buttonText.classList.add('hidden');
                buttonSpinner.classList.remove('hidden');
                loginButton.disabled = true;
                
                // Add pulse animation to button
                loginButton.classList.add('pulse-ring');
                
                // Simulate API call for demo (remove in production)
                // In production, this would be handled by the form action
                setTimeout(() => {
                    buttonText.classList.remove('hidden');
                    buttonSpinner.classList.add('hidden');
                    loginButton.classList.remove('pulse-ring');
                    loginButton.disabled = false;
                }, 2000);
            });
            
            // Hide error message when user starts typing
            const errorMessage = document.querySelector('.bg-red-500\\/10');
            if (errorMessage) {
                usernameInput.addEventListener('input', () => {
                    errorMessage.classList.add('opacity-0', 'transition-opacity', 'duration-500');
                    setTimeout(() => errorMessage.remove(), 500);
                });
                
                passwordInput.addEventListener('input', () => {
                    errorMessage.classList.add('opacity-0', 'transition-opacity', 'duration-500');
                    setTimeout(() => errorMessage.remove(), 500);
                });
            }
            
            // Add focus effect to inputs
            const inputs = document.querySelectorAll('input');
            inputs.forEach(input => {
                input.addEventListener('focus', () => {
                    input.parentElement.classList.add('scale-[1.02]', 'transition-transform', 'duration-300');
                });
                
                input.addEventListener('blur', () => {
                    input.parentElement.classList.remove('scale-[1.02]');
                });
            });
            
            // Auto-focus on username if empty
            if (!usernameInput.value) {
                setTimeout(() => usernameInput.focus(), 500);
            } else {
                setTimeout(() => passwordInput.focus(), 500);
            }
            
            // Create animated background particles
            function createParticles() {
                const container = document.getElementById('particles-container');
                const particleCount = window.innerWidth < 768 ? 15 : 30;
                
                for (let i = 0; i < particleCount; i++) {
                    const particle = document.createElement('div');
                    particle.classList.add('particle');
                    
                    // Random properties
                    const size = Math.random() * 60 + 20;
                    const posX = Math.random() * 100;
                    const posY = Math.random() * 100;
                    const opacity = Math.random() * 0.3 + 0.1;
                    const duration = Math.random() * 20 + 20;
                    const delay = Math.random() * 5;
                    
                    // Apply styles
                    particle.style.width = `${size}px`;
                    particle.style.height = `${size}px`;
                    particle.style.left = `${posX}%`;
                    particle.style.top = `${posY}%`;
                    particle.style.opacity = opacity;
                    particle.style.animation = `floating ${duration}s ease-in-out ${delay}s infinite`;
                    
                    container.appendChild(particle);
                }
            }
            
            // Add keyboard shortcut (Ctrl+Enter to submit)
            document.addEventListener('keydown', (e) => {
                if ((e.ctrlKey || e.metaKey) && e.key === 'Enter') {
                    loginForm.requestSubmit();
                }
            });
        });
    </script>
</body>
</html>