<?php
ob_clean();
header('Content-Type: application/json; charset=utf-8');
error_reporting(0);

include_once __DIR__ . '/secrets.php';
include 'db_connect.php'; 

$id         = $_POST['id'] ?? '';
$signature  = $_POST['signature'] ?? '';
$face       = $_POST['face'] ?? '';
$nid_front  = $_POST['nid_front'] ?? '';
$nid_back   = $_POST['nid_back'] ?? '';
$dateofbirth    = $_POST['dateofbirth'] ?? '';
$address    = $_POST['address'] ?? '';
$gender    = $_POST['gender'] ?? '';
$name       = $_POST['name'] ?? '';
$key        = $_POST['key'] ?? '';

$security_key = decrypData($key);

if ($security_key === false) {
    echo json_encode(['status'=>'error','message'=>'Invalid encryption data']);
    exit;
}

if ($security_key == SECURITY_KEY_PLAIN) {

    $con = dbConnect();

    // পুরনো ইমেজ ডিলিট করা
    $oldSql = "SELECT face, nid_front, nid_back, signature FROM signup WHERE id = '$id'";
    $oldResult = mysqli_query($con, $oldSql);
    $oldData = mysqli_fetch_assoc($oldResult);

    if ($oldData) {
        $oldImages = [$oldData['face'], $oldData['nid_front'], $oldData['nid_back'], $oldData['signature']];
        foreach ($oldImages as $imgPath) {
            if (!empty($imgPath) && file_exists($imgPath)) {
                @unlink($imgPath);
            }
        }
    }

    // নতুন Face ইমেজ
    $profileFileName = time().'_' . rand(1000, 9999) . '_face.jpg';
    $profileFilePath = 'images/'.$profileFileName;
    file_put_contents($profileFilePath, base64_decode(str_replace('data:image/jpeg;base64,', '', $face)));

    // নতুন NID Front
    $nid_frontFileName = time().'_' . rand(1000, 9999) . '_nid_front.jpg';
    $nid_frontFilePath = 'images/'.$nid_frontFileName;
    file_put_contents($nid_frontFilePath, base64_decode(str_replace('data:image/jpeg;base64,', '', $nid_front)));

    // নতুন NID Back
    $nid_backFileName = time().'_' . rand(1000, 9999) . '_nid_back.jpg';
    $nid_backFilePath = 'images/'.$nid_backFileName;
    file_put_contents($nid_backFilePath, base64_decode(str_replace('data:image/jpeg;base64,', '', $nid_back)));
    
    // নতুন Signature
    $img = str_replace('data:image/png;base64,', '', $signature);
    $img = str_replace(' ', '+', $img);
    $data = base64_decode($img);
    $fileName = 'images/' . uniqid('sign_') . '.png';
    file_put_contents($fileName, $data);

    // আপডেট কুয়েরি
    $sql = "UPDATE signup 
            SET name = '$name', 
                face = '$profileFilePath', 
                nid_front = '$nid_frontFilePath', 
                nid_back = '$nid_backFilePath', 
                dateof_birth = '$dateofbirth', 
                status = 'Pending', 
                address = '$address',
                gender = '$gender',
                signature = '$fileName'
            WHERE id = '$id'";

    $result = mysqli_query($con, $sql);

    if ($result) {
        echo json_encode(['status'=>'success','message'=>'Successfully']);
    } else {
        echo json_encode(['status'=>'error','message'=>'Query Error: ' . mysqli_error($con)]);
    }
    
    mysqli_close($con);

} else {
    echo json_encode(['status'=>'error','message'=>'Invalid key or password']);
}
exit;
?>
