<?php

include_once __DIR__ . '/secrets.php';
include 'db_connect.php';

$json = file_get_contents('php://input');
$data = json_decode($json, true);

$key = $data['key'];
$email = $data['email'];

$security_key = decrypData($key);

if ($security_key === false) {
    echo 'Invalid encryption data';
    exit;
}

if ($security_key == SECURITY_KEY_PLAIN && strlen($email) > 0) {

    $con = dbConnect();
    $url = 'https://app.bpluspro.xyz/social/';

    // ============ USER DATA ============
    $sql = "SELECT * FROM signup WHERE email = '$email'";
    $output = mysqli_query($con, $sql);

    if ($output && mysqli_num_rows($output) > 0) {

        $row = mysqli_fetch_assoc($output);
        $userid = $row['userid'];

        /* ===============================
           1️⃣ কতজন তাকে friend request পাঠিয়েছে (pending incoming)
        ==================================*/
        $sql_pending_in = "
            SELECT COUNT(*) AS total 
            FROM friends_request 
            WHERE receiver_id = '$userid' 
            AND status = 'pending'
        ";
        $res_pending_in = mysqli_query($con, $sql_pending_in);
        $pending_in = mysqli_fetch_assoc($res_pending_in)['total'];


        /* ===============================
           2️⃣ সে যতটি friend request accept করেছে (accepted outgoing)
        ==================================*/
        $sql_accept_out = "
            SELECT COUNT(*) AS total 
            FROM friends_request 
            WHERE sender_id = '$userid' 
            AND status = 'accepted'
        ";
        $res_accept_out = mysqli_query($con, $sql_accept_out);
        $accepted_out = mysqli_fetch_assoc($res_accept_out)['total'];


        /* ===============================
           3️⃣ তার request অন্যরা accept করেছে (accepted incoming)
        ==================================*/
        $sql_accept_in = "
            SELECT COUNT(*) AS total 
            FROM friends_request 
            WHERE receiver_id = '$userid' 
            AND status = 'accepted'
        ";
        $res_accept_in = mysqli_query($con, $sql_accept_in);
        $accepted_in = mysqli_fetch_assoc($res_accept_in)['total'];


        /* ===============================
           Final Response
        ==================================*/
        $temp = [
            'id' => $row['id'],
            'userid' => $row['userid'],
            'name' => $row['name'],
            'number' => $row['number'],
            'balance' => $row['balance'],
            'password' => $row['password'],
            'country' => $row['country'],
            'country_code' => $row['country_code'],
            'email' => $row['email'],
            'image' => $url . $row['image'],
            'time' => $row['time'],
            'status' => $row['status'],
            'cover' => $url . $row['cover'],
            'bpay' => $row['bpay'],
            'gender' => $row['gender'],
            'dateof_birth' => $row['dateof_birth'],
            'address' => $row['address'],
            'face' => $url . $row['face'],
            'nid_front' => $url . $row['nid_front'],
            'nid_back' => $url . $row['nid_back'],
            'signature' => $url . $row['signature'],
            'token' => $row['token'],
            'page' => $row['page'],
            // New Counts
            'pending_request_in' => $pending_in,      // কতজন তাকে pending request পাঠিয়েছে
            'accepted_out'       => $accepted_out,    // সে যতজনকে accept করেছে
            'accepted_in'        => $accepted_in      // তার sent request যতজন accept করেছে
        ];

        echo json_encode($temp, JSON_UNESCAPED_SLASHES);

    } else {
        echo json_encode(['error' => 'No data found']);
    }

    mysqli_close($con);

} else {
    echo json_encode(['error' => 'Invalid key']);
}

?>
