<?php

include_once __DIR__ . '/../secrets.php';

header('Content-Type: application/json; charset=utf-8');
include '../db_connect.php'; 

$json = file_get_contents('php://input');
$jsonArray = json_decode($json, true);

$data = $jsonArray[0];
$userid = $data['userid'];
$key = $data['key'];

$response = array();

$security_key = decrypData($key);

if ($security_key === false) {
    echo 'Invalid encryption data';
    exit;
}

if ($security_key == SECURITY_KEY_PLAIN) {
    $con = dbConnect();
    
    $sliderArray = array();
    $sliderSql = "SELECT * FROM image_slider ORDER BY id DESC"; 
    $sliderResult = mysqli_query($con, $sliderSql);

    while ($item = mysqli_fetch_assoc($sliderResult)) {
        $sliderArray[] = array(
            'id' => $item['id'],
            'image' => $item['image']
        );
    }
    

    $historyArray = array();
    $historySql = "SELECT * FROM history_table WHERE userid = '$userid' ORDER BY id DESC";
    $historyResult = mysqli_query( $con, $historySql );

    while ( $item = mysqli_fetch_assoc( $historyResult ) ) {
        $historyArray[] = array(
           'id' => $item[ 'id' ],
            'userid' => $item[ 'userid' ],
            'number' => $item[ 'number' ],
            'balance' => $item[ 'balance' ],
            'profit' => $item[ 'profit' ],
            'oldbalance' => $item[ 'oldbalance' ],
            'time' => $item[ 'time' ],
            'operator' => $item[ 'operator' ],
            'title' => $item[ 'title' ],
            'transid' => $item[ 'transid' ],
            'status' => $item[ 'status' ],
            'details' => $item[ 'details' ],
            'lastnumber' => $item[ 'lastnumber' ],
            'type' => $item[ 'type' ],
            'newbalance' => $item[ 'newbalance' ]
        );
    }
    
    

    $response[] = array(
        'slider' => $sliderArray,
        'history' => $historyArray
    );

    echo json_encode($response); 
}else {
    echo json_encode(['error' => 'Invalid key or password']);
}


?>
